[ env.ini ]
set var=CONF_REGION value="tr(1,World)"
set var=CONF_PROVIDER value="tr(2,Basic)"
set var=CONF_DESCRIPTION value="tr(3,User specified Bridged Ethernet configuration using a fixed IP address for the host PC(s).)"
set var=CONF_SERVICE value="tr(4,Bridged Ethernet)"
set var=CONF_DATE value=""
set var=CONF_TPVERSION value=1.2.0
set var=HOST_SETUP value=auto
set var=UPGRADE_URL value=http://www.speedtouch.com/upgrade500.htm
set var=ATM_addr value=8.35
set var=ATM_auto value=active
set var=ST_DHCP_SRV_ACTIVE value=yes
set var=ST_DHCP_POOL_START value="10.0.0.1"
set var=ST_DHCP_POOL_END value="10.0.0.254"
set var=ST_LAN_IP_ADDR value="10.0.0.138"
set var=ST_LAN_NET_MASK value="255.255.255.0"

[ wizard.ini ]
' ATM=PVC/ PPP=Settings
'----------------------------
def var=ATM type=grp desc="tr(5,Specify the details of the Bridged Ethernet Packet Service. All information should be provided by your ISP.)" alias="tr(6,Bridged Ethernet Packet Service)"
def var=ATM_addr type=combo grp=ATM alias="VPI/VCI" data="0.32,0.33,0.35,0.36,0.37,0.38,0.100,1.32,1.33,1.100,8.35,8.36,8.37,8.48,8.81" desc="tr(7,Choose a VPI/VCI from the list)"
def var=ATM_auto type=bool grp=ATM alias="tr(8,Auto-configured)" data="passive,active"
' LAN=Settings
'----------------------------
def var=LAN type=grp desc="tr(9,Specify the Local Area Network settings.)" alias="tr(10,LAN Settings)"
def var=ST_DHCP_SRV_ACTIVE type=bool grp=LAN alias="tr(11,DHCP Server)" data="no,yes" desc="tr(12,Start the DHCP server on the SpeedTouch)"
'ST Security
'-----------
def var=ST type=grp desc="tr(13,Specify user name and password to protect SpeedTouch administrative access.)" alias="tr(14,SpeedTouch Security)"
def var=%ST_SYS_USERNAME type=string grp=ST alias="tr(15,User Name)" desc="tr(16,Enter user name.)"
def var=%ST_SYS_PASSWORD type=passw grp=ST alias="tr(17,Password)" desc="tr(18,Enter your password.)" max=32
def var=dummy type=passwcheck grp=ST alias="tr(19,Confirm Password)" desc="tr(20,Re-enter your password)" linkvar=%ST_SYS_PASSWORD max=32

[ hostwizard.ini ]

[ phone.ini ]
add name=USB addr=usb.0.35 type=any logging=off
add name=PVC_1 addr=$ATM_addr type=any

[ bridge.ini ]
ifadd intf=Br1 dest=PVC_1
ifattach intf=Br1
ifadd intf=USB dest=USB logging=off
ifattach intf=USB logging=off
config age=300 filter=no_WAN_broadcast

[ pptp.ini ]

[ dhcp.ini ]
#if $ST_DHCP_SRV_ACTIVE=yes
config autodhcp=on scantime=10 trace=off state=enabled
#else
config autodhcp=on scantime=10 trace=off state=disabled
#endif
policy verifyfirst=on trustclient=on
pool add name=LAN_private
pool config name=LAN_private poolstart=$ST_DHCP_POOL_START poolend=$ST_DHCP_POOL_END netmask=255.255.255.0 gateway=$ST_LAN_IP_ADDR leasetime=7200

[ ethoa.ini ]

[ ipoa.ini ]

[ cip.ini ]

[ pppoa.ini ]

[ pppoe.ini ]

[ pppoerelay.ini ]

[ ip.ini ]
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=$ST_LAN_IP_ADDR netmask=$ST_LAN_NET_MASK intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=$ST_LAN_IP_ADDR
rtadd dst=224.0.0.0/4 intf=eth0

[ dhcr.ini ]
#if $ST_DHCP_SRV_ACTIVE=yes
ifconfig intf=eth0 relay=on
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138
#else
ifconfig intf=eth0 relay=off
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138
#endif

[ autopvc.ini ]
config mode=$ATM_auto type=bridge

[ system.ini ]
config upnp=enabled mdap=enabled dcache=enabled drst=enabled
#if $%ST_SYS_PASSWORD=""
setpassword password="" userid=$%ST_SYS_USERNAME
#else
setpassword password=$%ST_SYS_PASSWORD userid=$%ST_SYS_USERNAME
#endif

[ language.ini ]
langdef lang=nl charset=ISO-8859-1
t r="1, Wereld"
t r="2, Basis"
t r="3, Door de gebruiker opgegeven bridged-Ethernet-configuratie met vast IP-adres voor de PC('s)."
t r="4, Bridged Ethernet"
t r="5, Geef de details van de Bridged-Ethernet Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="6, Bridged-Ethernet Packet-service"
t r="7, Selecteer een VPI/VCI uit de lijst"
t r="8, Automatische configuratie"
t r="9, Geef de instellingen voor het lokale netwerk (LAN) op."
t r="10, LAN-instellingen"
t r="11, DHCP-server"
t r="12, Start de DHCP-server op de SpeedTouch."
t r="13, Geef de gebruikersnaam en het wachtwoord op waarmee u het beheer van de SpeedTouch wilt beveiligen."
t r="14, SpeedTouch-beveiliging"
t r="15, Gebruikersnaam"
t r="16, Geef uw gebruikersnaam in."
t r="17, Wachtwoord"
t r="18, Geef uw wachtwoord in."
t r="19, Wachtwoord bevestigen"
t r="20, Geef uw wachtwoord nogmaals in."
langdef lang=fr charset=ISO-8859-1
t r="1, Monde"
t r="2, Basic"
t r="3, Configuration Ethernet ponte spcifie par l'utilisateur avec une adresse IP fixe pour le(s) PC hte(s)."
t r="4, Ethernet pont"
t r="5, Spcifiez les dtails relatifs au service de transmission par paquets. Toutes ces informations doivent tre fournies par votre FAI."
t r="6, Service de transmission par paquets Ethernet pont"
t r="7, Slectionnez un VPI/VCI dans la liste"
t r="8, Auto-configur"
t r="9, Prcisez les paramtres LAN (rseau local)."
t r="10, Paramtres LAN"
t r="11, Serveur DHCP"
t r="12, Dmarrez le serveur DHCP sur le SpeedTouch"
t r="13, Indiquez un nom d'utilisateur et un mot de passe pour protger l'accs administratif de SpeedTouch."
t r="14, Scurit SpeedTouch"
t r="15, Nom d'utilisateur"
t r="16, Entrez un nom d'utilisateur."
t r="17, Mot de passe"
t r="18, Entrez votre mot de passe."
t r="19, Confirmer le mot de passe"
t r="20, Entrez  nouveau le mot de passe"
langdef lang=de charset=ISO-8859-1
t r="1, Welt"
t r="2, Grundlegende"
t r="3, Der Anwender definierte die Konfiguration des Bridged Ethernet unter Verwendung einer festen IP-Adresse fr den bzw. die Hostcomputer."
t r="4, Bridged Ethernet"
t r="5, Geben Sie die Einzelheiten zum Bridged Ethernet-Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="6, Bridged Ethernet-Paketdienst"
t r="7, Whlen Sie einen VPI/VCI-Eintrag aus der Liste aus"
t r="8, Automatisch konfiguriert"
t r="9, Legen Sie die Einstellungen fr das LAN (Local Area Network) fest."
t r="10, LAN-Einstellungen"
t r="11, DHCP-Server"
t r="12, Starten Sie den DHCP-Server des SpeedTouch."
t r="13, Geben Sie den Benutzernamen und das Kennwort an, um den Administratorzugriff auf das SpeedTouch zu schtzen."
t r="14, SpeedTouch Sicherheit"
t r="15, Benutzername"
t r="16, Geben Sie den Benutzernamen ein."
t r="17, Kennwort"
t r="18, Geben Sie das Kennwort ein."
t r="19, Kennwort besttigen"
t r="20, Geben Sie das Kennwort erneut ein."
langdef lang=it charset=ISO-8859-1
t r="1, Mondo"
t r="2, Standard"
t r="3, L'utente ha specificato una configurazione bridged Ethernet utilizzando un indirizzo IP statico per il/i PC host."
t r="4, Bridged Ethernet"
t r="5, Specificare i dettagli per la trasmissione di pacchetti bridged Ethernet. Tutte le informazioni devono essere fornite dall'ISP."
t r="6, Trasmissione di pacchetti bridged Ethernet"
t r="7, Scegliere un VPI/VCI dall'elenco"
t r="8, Autoconfigurato"
t r="9, Specificare le impostazioni per la LAN."
t r="10, Impostazioni LAN"
t r="11, Server DHCP"
t r="12, Avviare il server DHCP sullo SpeedTouch"
t r="13, Specificare un nome utente e una password per proteggere l'accesso amministrativo dello SpeedTouch."
t r="14, Sicurezza SpeedTouch"
t r="15, Nome utente"
t r="16, Immettere il nome utente."
t r="17, Password"
t r="18, Immettere la password."
t r="19, Conferma password"
t r="20, Immettere nuovamente la password."
langdef lang=pt charset=ISO-8859-1
t r="1, Mundo"
t r="2, Bsico"
t r="3, Configurao de Ethernet com ponte especificada pelo usurio usando um endereo IP fixo para host PC(s)."
t r="4, Ethernet com ponte"
t r="5, Especifique os detalhes do Servio de Pacote da Ethernet com ponte. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="6, Servio de Pacote da Ethernet com ponte"
t r="7, Escolha um VPI/VCI na lista"
t r="8, Auto configurado"
t r="9, Especifique as configuraes da Rede de Comunicao Local (Local Area Network - LAN)."
t r="10, Configuraes da LAN"
t r="11, Servidor DHCP"
t r="12, Inicie o servidor DHCP no SpeedTouch"
t r="13, Especifique o nome do usurio e a senha para proteger o acesso administrativo do SpeedTouch."
t r="14, Segurana do SpeedTouch"
t r="15, Nome do usurio"
t r="16, Digite o nome do usurio."
t r="17, Senha"
t r="18, Digite sua senha."
t r="19, Confirme a senha"
t r="20, Digite novamente sua senha"
langdef lang=es charset=ISO-8859-1
t r="1, Mundial"
t r="2, Bsico"
t r="3, Configuracin Bridged Ethernet (Ethernet puenteada) especificada por el usuario mediante una direccin IP fija para las computadoras host."
t r="4, Bridged Ethernet (Ethernet puenteada)"
t r="5, Indique los detalles del servicio de paquetes Bridged Ethernet. Toda la informacin debe proporcionarla el ISP."
t r="6, Servicio de paquetes Bridged Ethernet"
t r="7, Elija un identificador VPI/VCI de la lista"
t r="8, Configurado automticamente"
t r="9, Especifique la configuracin de la red de rea local (LAN)"
t r="10, Configuracin de LAN"
t r="11, Servidor DHCP"
t r="12, Inicie el servidor DHCP en el dispositivo SpeedTouch"
t r="13, Indique el nombre de usuario y la contrasea para proteger el acceso administrativo a SpeedTouch."
t r="14, Seguridad de SpeedTouch"
t r="15, Nombre de usuario"
t r="16, Escriba el nombre de usuario."
t r="17, Contrasea"
t r="18, Escriba la contrasea."
t r="19, Confirme la contrasea"
t r="20, Vuelva a escribir la contrasea"
langdef lang=sv charset=ISO-8859-1
t r="1, Vrld"
t r="2, Enkel"
t r="3, Anvnd angiven Bridged Ethernet-konfiguration med fast IP-adress fr vrd-PC:n."
t r="4, Bridged Ethernet"
t r="5, Ange information om Bridged Ethernet Packet Service. Din ISP ska kunna ge all information."
t r="6, Bridged Ethernet Packet Service"
t r="7, Vlj VPI/VCI frn listan"
t r="8, Autokonfigurerad"
t r="9, Ange instllningar fr lokalt ntverk (LAN)."
t r="10, LAN-instllningar"
t r="11, DHCP-server:"
t r="12, Starta DHCP-servern p SpeedTouch"
t r="13, Ange anvndarnamn och lsenord fr att skydda administrativ tkomst till SpeedTouch."
t r="14, SpeedTouch-skerhet"
t r="15, Anvndarnamn"
t r="16, Ange anvndarnamn."
t r="17, Lsenord"
t r="18, Ange lsenord."
t r="19, Bekrfta lsenord"
t r="20, Ange ditt lsenord igen"

[ endofarch ]
